#!/bin/sh
#	@(#) tree      1.1  30/11/95       by Jordi Sanfeliu
#					email: jordi@fibranet.cat
#
#	Initial version:  1.0  30/11/95
#	Next version   :  1.1  24/02/97   Now, with symbolic links
#
#	Description: Tree is a tool for view the directory tree (obvious :-) )
#
#	Syntax: tree [directory]
#
search () {
   for dir in `echo *`
   do
      if [ -d $dir ] ; then
         zz=0
         while [ $zz != $deep ]
         do
            echo -n "|   "
            zz=`expr $zz + 1`
         done
         if [ -L $dir ] ; then
            echo "+---$dir" `ls -l $dir | sed 's/^.*'$dir' //'`
         else
            echo "+---$dir"
            cd $dir
            deep=`expr $deep + 1`
            search    # with recursivity ;-)
            numdirs=`expr $numdirs + 1`
         fi
      fi
   done
   cd ..
   if [ $deep ] ; then
      swfi=1
   fi
   deep=`expr $deep - 1`
}

# - Main -
if [ $# = 0 ] ; then
   cd `pwd`
else
   cd $1
fi
echo "Initial directory = `pwd`"
swfi=0
deep=0
numdirs=0
zz=0

while [ $swfi != 1 ]
do
   search
done
echo "Total directories = $numdirs"
