/*
 * fiwix/drivers/char/defkeymap.c
 *
 * Copyright 2018-2022, Jordi Sanfeliu. All rights reserved.
 * Distributed under the terms of the Fiwix License.
 */

#include <fiwix/keyboard.h>
#include <fiwix/string.h>

#define BS	127	/* backspace */

__key_t keymap[NR_MODIFIERS * NR_SCODES] = {
/*
 * Standard US keyboard (default keymap) with 16 modifiers
 *																		Shift
 *										Shift				Shift		Shift	AltGr	AltGr
 * SCAN						Shift		Shift	AltGr	AltGr		Shift	AltGr	AltGr	Ctrl	Ctrl	Ctrl	Ctrl
 * CODE  KEY		Base	Shift	AltGr	AltGr	Ctrl	Ctrl	Ctrl	Ctrl	Alt	Alt	Alt	Alt	Alt	Alt	Alt	Alt
 * ==================================================================================================================================================== */
/*  00 - 0	*/	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,
/*  01 - ESC	*/	C('['),	C('['),	0,	0,	0,	0,	0,	0,	A('['),	0,	0,	0,	0,	0,	0,	0,
/*  02 - 1	*/	'1',	'!',	0,	0,	0,	0,	0,	0,	A('1'),	0,	0,	0,	0,	0,	0,	0,
/*  03 - 2	*/	'2',	'@',	'@',	0,	0,	0,	0,	0,	A('2'),	0,	0,	0,	0,	0,	0,	0,
/*  04 - 3	*/	'3',	'#',	0,	0,	C('['),	0,	0,	0,	A('3'),	0,	0,	0,	0,	0,	0,	0,
/*  05 - 4	*/	'4',	'$',	'$',	0,	C('\\'),0,	0,	0,	A('4'),	0,	0,	0,	0,	0,	0,	0,
/*  06 - 5	*/	'5',	'%',	0,	0,	C(']'),	0,	0,	0,	A('5'),	0,	0,	0,	0,	0,	0,	0,
/*  07 - 6	*/	'6',	'^',	0,	0,	C('^'),	0,	0,	0,	A('6'),	0,	0,	0,	0,	0,	0,	0,
/*  08 - 7	*/	'7',	'&',	'{',	0,	C('_'),	0,	0,	0,	A('7'),	0,	0,	0,	0,	0,	0,	0,
/*  09 - 8	*/	'8',	'*',	'[',	0,	BS,	0,	0,	0,	A('8'),	0,	0,	0,	0,	0,	0,	0,
/*  10 - 9	*/	'9',	'(',	']',	0,	0,	0,	0,	0,	A('9'),	0,	0,	0,	0,	0,	0,	0,
/*  11 - 0	*/	'0',	')',	'}',	0,	0,	0,	0,	0,	A('0'),	0,	0,	0,	0,	0,	0,	0,
/*  12 - -_	*/	'-',	'_',	'\\',	0,	C('_'),	0,	0,	0,	A('-'),	0,	0,	0,	0,	0,	0,	0,
/*  13 - =+	*/	'=',	'+',	0,	0,	0,	0,	0,	0,	A('='),	0,	0,	0,	0,	0,	0,	0,
/*  14 - BS	*/	BS,	BS,	0,	0,	0,	0,	0,	0,	A(BS),	0,	0,	0,	0,	0,	0,	0,
/*  15 - TAB	*/	'\t',	'\t',	0,	0,	0,	0,	0,	0,	A('\t'),0,	0,	0,	0,	0,	0,	0,
/*  16 - q	*/	L('q'),	L('Q'),	L('q'),	L('Q'),	C('Q'),	0,	0,	0,	A('q'),	0,	0,	0,	0,	0,	0,	0,
/*  17 - w	*/	L('w'),	L('W'),	L('w'),	L('W'),	C('W'),	0,	0,	0,	A('w'),	0,	0,	0,	0,	0,	0,	0,
/*  18 - e	*/	L('e'),	L('E'),	L('e'),	L('E'),	C('E'),	0,	0,	0,	A('e'),	0,	0,	0,	0,	0,	0,	0,
/*  19 - r	*/	L('r'),	L('R'),	L('r'),	L('R'),	C('R'),	0,	0,	0,	A('r'),	0,	0,	0,	0,	0,	0,	0,
/*  20 - t	*/	L('t'),	L('T'),	L('t'),	L('T'),	C('T'),	0,	0,	0,	A('t'),	0,	0,	0,	0,	0,	0,	0,
/*  21 - y	*/	L('y'),	L('Y'),	L('y'),	L('Y'),	C('Y'),	0,	0,	0,	A('y'),	0,	0,	0,	0,	0,	0,	0,
/*  22 - u	*/	L('u'),	L('U'),	L('u'),	L('U'),	C('U'),	0,	0,	0,	A('u'),	0,	0,	0,	0,	0,	0,	0,
/*  23 - i	*/	L('i'),	L('I'),	L('i'),	L('I'),	C('I'),	0,	0,	0,	A('i'),	0,	0,	0,	0,	0,	0,	0,
/*  24 - o	*/	L('o'),	L('O'),	L('o'),	L('O'),	C('O'),	0,	0,	0,	A('o'),	0,	0,	0,	0,	0,	0,	0,
/*  25 - p	*/	L('p'),	L('P'),	L('p'),	L('P'),	C('P'),	0,	0,	0,	A('p'),	0,	0,	0,	0,	0,	0,	0,
/*  26 - [{	*/	'[',	'{',	0,	0,	C('['),	0,	0,	0,	A('['),	0,	0,	0,	0,	0,	0,	0,
/*  27 - ]}	*/	']',	'}',	'~',	0,	C(']'),	0,	0,	0,	A(']'),	0,	0,	0,	0,	0,	0,	0,
/*  28 - CR	*/	CR,	CR,	CR,	CR,	CR,	0,	0,	0,	A(CR),	0,	0,	0,	0,	0,	0,	0,
/*  29 - LCTRL	*/	LCTRL,	LCTRL,	LCTRL,	LCTRL,	LCTRL,	0,	0,	0,	LCTRL,	0,	0,	0,	0,	0,	0,	0,
/*  30 - a	*/	L('a'),	L('A'),	L('a'),	L('A'),	C('A'),	0,	0,	0,	A('a'),	0,	0,	0,	0,	0,	0,	0,
/*  31 - s	*/	L('s'),	L('S'),	L('s'),	L('S'),	C('S'),	0,	0,	0,	A('s'),	0,	0,	0,	0,	0,	0,	0,
/*  32 - d	*/	L('d'),	L('D'),	L('d'),	L('D'),	C('D'),	0,	0,	0,	A('d'),	0,	0,	0,	0,	0,	0,	0,
/*  33 - f	*/	L('f'),	L('F'),	L('f'),	L('F'),	C('F'),	0,	0,	0,	A('f'),	0,	0,	0,	0,	0,	0,	0,
/*  34 - g	*/	L('g'),	L('G'),	L('g'),	L('G'),	C('G'),	0,	0,	0,	A('g'),	0,	0,	0,	0,	0,	0,	0,
/*  35 - h	*/	L('h'),	L('H'),	L('h'),	L('H'),	C('H'),	0,	0,	0,	A('h'),	0,	0,	0,	0,	0,	0,	0,
/*  36 - j	*/	L('j'),	L('J'),	L('j'),	L('J'),	C('J'),	0,	0,	0,	A('j'),	0,	0,	0,	0,	0,	0,	0,
/*  37 - k	*/	L('k'),	L('K'),	L('k'),	L('K'),	C('K'),	0,	0,	0,	A('k'),	0,	0,	0,	0,	0,	0,	0,
/*  38 - l	*/	L('l'),	L('L'),	L('l'),	L('L'),	C('L'),	0,	0,	0,	A('l'),	0,	0,	0,	0,	0,	0,	0,
/*  39 - ;:	*/	';',	':',	0,	0,	0,	0,	0,	0,	A(';'),	0,	0,	0,	0,	0,	0,	0,
/*  40 - '"	*/	'\'',	'"',	0,	0,	C('G'),	0,	0,	0,	A('\''),0,	0,	0,	0,	0,	0,	0,
/*  41 - `~	*/	'`',	'~',	0,	0,	0,	0,	0,	0,	A('`'),	0,	0,	0,	0,	0,	0,	0,
/*  42 - LSHF	*/	LSHIFT,	LSHIFT,	LSHIFT,	LSHIFT,	LSHIFT,	0,	0,	0,	LSHIFT,	0,	0,	0,	0,	0,	0,	0,
/*  43 - \|	*/	'\\',	'|',	0,	0,	C('\\'),0,	0,	0,	A('\\'),0,	0,	0,	0,	0,	0,	0,
/*  44 - z	*/	L('z'),	L('Z'),	L('z'),	L('Z'),	C('Z'),	0,	0,	0,	A('z'),	0,	0,	0,	0,	0,	0,	0,
/*  45 - x	*/	L('x'),	L('X'),	L('x'),	L('X'),	C('X'),	0,	0,	0,	A('x'),	0,	0,	0,	0,	0,	0,	0,
/*  46 - c	*/	L('c'),	L('C'),	L('c'),	L('C'),	C('C'),	0,	0,	0,	A('c'),	0,	0,	0,	0,	0,	0,	0,
/*  47 - v	*/	L('v'),	L('V'),	L('v'),	L('V'),	C('V'),	0,	0,	0,	A('v'),	0,	0,	0,	0,	0,	0,	0,
/*  48 - b	*/	L('b'),	L('B'),	L('b'),	L('B'),	C('B'),	0,	0,	0,	A('b'),	0,	0,	0,	0,	0,	0,	0,
/*  49 - n	*/	L('n'),	L('N'),	L('n'),	L('N'),	C('N'),	0,	0,	0,	A('n'),	0,	0,	0,	0,	0,	0,	0,
/*  50 - m	*/	L('m'),	L('M'),	L('m'),	L('M'),	C('M'),	0,	0,	0,	A('m'),	0,	0,	0,	0,	0,	0,	0,
/*  51 - ,<	*/	',',	'<',	0,	0,	0,	0,	0,	0,	A(','),	0,	0,	0,	0,	0,	0,	0,
/*  52 - .>	*/	'.',	'>',	0,	0,	0,	0,	0,	0,	A('.'),	0,	0,	0,	0,	0,	0,	0,
/*  53 - /?	*/	SLASH,	'?',	0,	0,	BS,	0,	0,	0,	A('/'),	0,	0,	0,	0,	0,	0,	0,
/*  54 - RSHF	*/	RSHIFT,	RSHIFT,	RSHIFT,	RSHIFT,	RSHIFT,	0,	0,	0,	RSHIFT,	0,	0,	0,	0,	0,	0,	0,
/*  55 - *	*/	ASTSK,	ASTSK,	ASTSK,	ASTSK,	ASTSK,	0,	0,	0,	ASTSK,	0,	0,	0,	0,	0,	0,	0,
/*  56 - ALT	*/	ALT,	ALT,	ALT,	ALT,	ALT,	0,	0,	0,	ALT,	0,	0,	0,	0,	0,	0,	0,
/*  57 - SPC	*/	' ',	' ',	0,	0,	0,	0,	0,	0,	A(' '),	0,	0,	0,	0,	0,	0,	0,
/*  58 - CAPS	*/	CAPS,	CAPS,	CAPS,	CAPS,	CAPS,	0,	0,	0,	CAPS,	0,	0,	0,	0,	0,	0,	0,
/*  59 - F1	*/	F1,	SF1,	0,	0,	F1,	0,	0,	0,	AF1,	0,	0,	0,	0,	0,	0,	0,
/*  60 - F2	*/	F2,	SF2,	0,	0,	F2,	0,	0,	0,	AF2,	0,	0,	0,	0,	0,	0,	0,
/*  61 - F3	*/	F3,	SF3,	0,	0,	F3,	0,	0,	0,	AF3,	0,	0,	0,	0,	0,	0,	0,
/*  62 - F4	*/	F4,	SF4,	0,	0,	F4,	0,	0,	0,	AF4,	0,	0,	0,	0,	0,	0,	0,
/*  63 - F5	*/	F5,	SF5,	0,	0,	F5,	0,	0,	0,	AF5,	0,	0,	0,	0,	0,	0,	0,
/*  64 - F6	*/	F6,	SF6,	0,	0,	F6,	0,	0,	0,	AF6,	0,	0,	0,	0,	0,	0,	0,
/*  65 - F7	*/	F7,	SF7,	0,	0,	F7,	0,	0,	0,	AF7,	0,	0,	0,	0,	0,	0,	0,
/*  66 - F8	*/	F8,	SF8,	0,	0,	F8,	0,	0,	0,	AF8,	0,	0,	0,	0,	0,	0,	0,
/*  67 - F9	*/	F9,	SF9,	0,	0,	F9,	0,	0,	0,	AF9,	0,	0,	0,	0,	0,	0,	0,
/*  68 - F10	*/	F10,	SF10,	0,	0,	F10,	0,	0,	0,	AF10,	0,	0,	0,	0,	0,	0,	0,
/*  69 - NUMS	*/	NUMS,	NUMS,	NUMS,	NUMS,	NUMS,	0,	0,	0,	NUMS,	0,	0,	0,	0,	0,	0,	0,
/*  70 - SCRL	*/	SCRL,	SCRL3,	SCRL2,	0,	SCRL4,	0,	0,	0,	SCRL,	0,	0,	0,	0,	0,	0,	0,
/*  71 - HOME/7	*/	HOME,	HOME,	HOME,	HOME,	HOME,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,
/*  72 - UP  /8	*/	UP,	UP,	UP,	UP,	UP,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,
/*  73 - PGUP/9	*/	PGUP,	PGUP,	PGUP,	PGUP,	PGUP,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,
/*  74 - MINUS	*/	MINUS,	MINUS,	MINUS,	MINUS,	MINUS,	0,	0,	0,	MINUS,	0,	0,	0,	0,	0,	0,	0,
/*  75 - LEFT/4	*/	LEFT,	LEFT,	LEFT,	LEFT,	LEFT,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,
/*  76 - MID /5	*/	MID,	MID,	MID,	MID,	MID,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,
/*  77 - RIGH/6	*/	RIGHT,	RIGHT,	RIGHT,	RIGHT,	RIGHT,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,
/*  78 - PLUS	*/	PLUS,	PLUS,	PLUS,	PLUS,	PLUS,	0,	0,	0,	PLUS,	0,	0,	0,	0,	0,	0,	0,
/*  79 - END /1	*/	END,	END,	END,	END,	END,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,
/*  80 - DOWN/2	*/	DOWN,	DOWN,	DOWN,	DOWN,	DOWN,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,
/*  81 - PGDN/3	*/	PGDN,	PGDN,	PGDN,	PGDN,	PGDN,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,
/*  82 - INS /0	*/	INS,	INS,	INS,	INS,	INS,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,
/*  83 - DEL /.	*/	DEL,	DEL,	DEL,	DEL,	DEL,	0,	0,	0,	DEL,	0,	0,	0,	0,	0,	0,	0,
/*  84 - SYSRQ	*/	SYSRQ,	0,	0,	0,	0,	0,	0,	0,	SYSRQ,	0,	0,	0,	0,	0,	0,	0,
/*  85 -	*/	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,
/*  86 - <>	*/	'<',	'>',	'|',	0,	0,	0,	0,	0,	A('<'),	0,	0,	0,	0,	0,	0,	0,
/*  87 - F11	*/	SF1,	SF1,	0,	0,	F11,	0,	0,	0,	AF11,	0,	0,	0,	0,	0,	0,	0,
/*  88 - F12	*/	SF2,	SF2,	0,	0,	F12,	0,	0,	0,	AF12,	0,	0,	0,	0,	0,	0,	0,
/*  89 -	*/	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,
/*  90 -	*/	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,
/*  91 -	*/	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,
/*  92 -	*/	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,
/*  93 -	*/	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,
/*  94 -	*/	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,
/*  95 -	*/	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,
/*  96 - E0ENTER*/	E0ENTER,E0ENTER,E0ENTER,E0ENTER,E0ENTER,0,	0,	0,	E0ENTER,0,	0,	0,	0,	0,	0,	0,
/*  97 - RCTRL	*/	RCTRL,	RCTRL,	RCTRL,	RCTRL,	RCTRL,	0,	0,	0,	RCTRL,	0,	0,	0,	0,	0,	0,	0,
/*  98 - E0SLASH*/	E0SLASH,E0SLASH,E0SLASH,E0SLASH,E0SLASH,0,	0,	0,	E0SLASH,0,	0,	0,	0,	0,	0,	0,
/*  99 -	*/	0,	0,	0,	0,	C('\\'),0,	0,	0,	C('\\'),0,	0,	0,	0,	0,	0,	0,
/* 100 - ALTGR	*/	ALTGR,	ALTGR,	ALTGR,	ALTGR,	ALTGR,	0,	0,	0,	ALTGR,	0,	0,	0,	0,	0,	0,	0,
/* 101 -	*/	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,
/* 102 - E0HOME	*/	E0HOME,	E0HOME,	E0HOME,	E0HOME,	E0HOME,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,
/* 103 - E0UP  	*/	E0UP,	E0UP,	E0UP,	E0UP,	E0UP,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,
/* 104 - E0PGUP	*/	E0PGUP,	E0PGUP,	E0PGUP,	E0PGUP,	E0PGUP,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,
/* 105 - E0LEFT	*/	E0LEFT,	E0LEFT,	E0LEFT,	E0LEFT,	E0LEFT,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,
/* 106 - E0RIGHT*/	E0RIGHT,E0RIGHT,E0RIGHT,E0RIGHT,E0RIGHT,0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,
/* 107 - E0END	*/	E0END,	E0END,	E0END,	E0END,	E0END,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,
/* 108 - E0DOWN	*/	E0DOWN,	E0DOWN,	E0DOWN,	E0DOWN,	E0DOWN,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,
/* 109 - E0PGDN	*/	E0PGDN,	E0PGDN,	E0PGDN,	E0PGDN,	E0PGDN,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,
/* 110 - E0INS	*/	E0INS,	E0INS,	E0INS,	E0INS,	E0INS,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,
/* 111 - E0DEL	*/	E0DEL,	E0DEL,	E0DEL,	E0DEL,	E0DEL,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,
/* 112 -	*/	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,
/* 113 -	*/	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,
/* 114 -	*/	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,
/* 115 -	*/	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,
/* 116 -	*/	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,
/* 117 -	*/	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,
/* 118 -	*/	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,
/* 119 -	*/	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,
/* 120 -	*/	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,
/* 121 -	*/	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,
/* 122 -	*/	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,
/* 123 -	*/	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,
/* 124 -	*/	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,
/* 125 -	*/	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,
/* 126 -	*/	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,
/* 127 -	*/	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,
};
