# return if this is not a terminal
if [ ! -t 0 ] ; then
    return
fi

# only set if PS1 is unchanged or for color terminals
if [ '(' "$PS1" = "[(\u) \w]\\$ " ')' -o -n "${prompt_color_force}" ] ; then

    PROMPT_COLOR="${PROMPT_COLOR:-32}"
    PROMPT_USERHOST="${PROMPT_USERHOST:-(\u)}"
    PROMPT_SEPARATOR="${PROMPT_SEPARATOR:-:}"
    PROMPT_DIRECTORY="${PROMPT_DIRECTORY:-\w}"
    colorpre='\[\e['
    colorsuf='m\]'
    colorreset="${colorpre}0${colorsuf}"
    PS1='${PROMPT_START@P}'"${colorpre}"'${PROMPT_COLOR}'"${colorsuf}"'${PROMPT_USERHOST@P}'"${colorreset}"'${PROMPT_SEPARATOR@P}'"${colorpre}"'${PROMPT_DIR_COLOR:-${PROMPT_COLOR}}'"${colorsuf}"'${PROMPT_DIRECTORY@P}'"${colorreset}"'${PROMPT_END@P}\$'"${colorreset} "

    prompt_default() {
        PROMPT_COLOR="$1"
        PROMPT_DIR_COLOR="$2"
        PROMPT_SEPARATOR=':'
        PROMPT_DIRECTORY='\w'
        PROMPT_START='['
        PROMPT_END=']'
    }

fi
